/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.definition.geometry;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.loading.definition.geometry.GeometryPolyIndex;
import software.bernie.geckolib.util.JsonUtil;

@ApiStatus.Internal
public record GeometryPolyIndices(Either<GeometryPolyIndex[], GeometryPolyIndex[]> trisOrQuads) {
    public Optional<GeometryPolyIndex[]> tris() {
        return this.trisOrQuads.left();
    }

    public Optional<GeometryPolyIndex[]> quads() {
        return this.trisOrQuads.right();
    }

    public static JsonDeserializer<GeometryPolyIndices> gsonDeserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonArray array = json.getAsJsonArray();
            GeometryPolyIndex[] indices = JsonUtil.jsonArrayToObjectArray(array, context, GeometryPolyIndex.class);
            Either trisOrQuads = array.isEmpty() || array.get(0).getAsJsonArray().size() == 3 ? Either.left((Object)indices) : Either.right((Object)indices);
            return new GeometryPolyIndices((Either<GeometryPolyIndex[], GeometryPolyIndex[]>)trisOrQuads);
        };
    }
}

